/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.payroll.bonus.BonusConst;

import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PdPaymentDto;
import jp.mosp.common.common.MospException;

public class PdPaymentDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "UD_PAYMENT";
	public static final String KEY_1 = "K_CODE"   ;	// ЈR[h
	public static final String KEY_2 = "CALC_DATE";	// vZN
	
	// 
	public static final String COL_K_CODE               = "K_CODE"              ;	// ЈR[h
	public static final String COL_CALC_DATE            = "CALC_DATE"           ;	// vZN
	public static final String COL_PAYDAY               = "PAYDAY"              ;	// ^x
	public static final String COL_CALC_STATUS          = "CALC_STATUS"         ;	// vZXe[^X
	public static final String COL_K_NAME               = "K_NAME"              ;	// Ј
	public static final String COL_STATION_CODE         = "STATION_CODE"        ;	// R[h
	public static final String COL_POSITION_CODE        = "POSITION_CODE"       ;	// EʃR[h
	public static final String COL_EMPLOYMENT_TYPE      = "EMPLOYMENT_TYPE"     ;	// ٗp敪
	public static final String COL_PRESENCE             = "PRESENCE"            ;	// oΓ
	public static final String COL_WORK_ON_HOLIDAY      = "WORK_ON_HOLIDAY"     ;	// xoΓ
	public static final String COL_PARTICULAR_HOLIDAY   = "PARTICULAR_HOLIDAY"  ;	// ʋxɓ
	public static final String COL_PAID_HOLIDAY         = "PAID_HOLIDAY"        ;	// Lxɓ
	public static final String COL_ABSENCE              = "ABSENCE"             ;	// Γ
	public static final String COL_PAID_HOLIDAY_REST    = "PAID_HOLIDAY_REST"   ;	// Lc
	public static final String COL_PAYMENT_HOURS        = "PAYMENT_HOURS"       ;	// 
	public static final String COL_ARRIVE_LATE          = "ARRIVE_LATE"         ;	// x
	public static final String COL_EFFORT_TIME          = "EFFORT_TIME"         ;	// ʁAcƎ
	public static final String COL_EFFORT_ALLOWANCE     = "EFFORT_ALLOWANCE"    ;	// ʁAcƎ蓖
	public static final String COL_LATE_NIGHT           = "LATE_NIGHT"          ;	// [鎞
	public static final String COL_LATE_NIGHT_ALLOWANCE = "LATE_NIGHT_ALLOWANCE";	// [蓖
	public static final String COL_OVER_LATE            = "OVER_LATE"           ;	// [cƎ
	public static final String COL_OVER_LATE_ALLOWANCE  = "OVER_LATE_ALLOWANCE" ;	// [cƎ蓖
	public static final String COL_HOLIDAY_TIME         = "HOLIDAY_TIME"        ;	// x
	public static final String COL_HOLIDAY_ALLOWANCE    = "HOLIDAY_ALLOWANCE"   ;	// x蓖
	public static final String COL_ATTENDANCE_13        = "ATTENDANCE_13"       ;	// ΑӍ13
	public static final String COL_ATTENDANCE_14        = "ATTENDANCE_14"       ;	// ΑӍ14
	public static final String COL_INSTITUTIONAL_ABS    = "INSTITUTIONAL_ABS"   ;	// xΓ
	public static final String COL_OTHER_ATTENDANCE     = "OTHER_ATTENDANCE"    ;	// ̑Αӓ
	public static final String COL_BASIC_SALARY         = "BASIC_SALARY"        ;	// {
	public static final String COL_ABILITY1_ALLOWANCE   = "ABILITY1_ALLOWANCE"  ;	// E\蓖1
	public static final String COL_ABILITY2_ALLOWANCE   = "ABILITY2_ALLOWANCE"  ;	// E\蓖2
	public static final String COL_FAMILY_ALLOWANCE     = "FAMILY_ALLOWANCE"    ;	// }{蓖
	public static final String COL_ALLOWANCE_05         = "ALLOWANCE_05"        ;	// x05
	public static final String COL_ALLOWANCE_06         = "ALLOWANCE_06"        ;	// x06
	public static final String COL_CUT_FOR_MISSING      = "CUT_FOR_MISSING"     ;	// FΌz
	public static final String COL_CUT_FOR_SHORT        = "CUT_FOR_SHORT"       ;	// Ezo
	public static final String COL_ALLOWANCE_09         = "ALLOWANCE_09"        ;	// x09
	public static final String COL_ALLOWANCE_10         = "ALLOWANCE_10"        ;	// x10
	public static final String COL_ALLOWANCE_11         = "ALLOWANCE_11"        ;	// x11
	public static final String COL_ALLOWANCE_12         = "ALLOWANCE_12"        ;	// x12
	public static final String COL_ALLOWANCE_13         = "ALLOWANCE_13"        ;	// x13
	public static final String COL_DATE_ALLOWANCE       = "DATE_ALLOWANCE"      ;	// t蓖
	public static final String COL_ALLOWANCE_15         = "ALLOWANCE_15"        ;	// x15
	public static final String COL_ALLOWANCE_16         = "ALLOWANCE_16"        ;	// x16
	public static final String COL_ALLOWANCE_17         = "ALLOWANCE_17"        ;	// x17
	public static final String COL_COMMUTATION          = "COMMUTATION"         ;	// ʋΔ
	public static final String COL_COMMUTATION_TAX      = "COMMUTATION_TAX"     ;	// ېŒʋΔ
	public static final String COL_OVERTIME_ALLOWANCE   = "OVERTIME_ALLOWANCE"  ;	// E[Ex
	public static final String COL_CUT_FROM_BASIC       = "CUT_FROM_BASIC"      ;	// z
	public static final String COL_HEALTH_INSURANCE     = "HEALTH_INSURANCE"    ;	// Nی
	public static final String COL_PENSION_INSURANCE    = "PENSION_INSURANCE"   ;	// Nی
	public static final String COL_PENSION_FUND         = "PENSION_FUND"        ;	// N
	public static final String COL_EMPLOYEE_INSURANCE   = "EMPLOYEE_INSURANCE"  ;	// ٗpی
	public static final String COL_INCOME_TAX           = "INCOME_TAX"          ;	// 
	public static final String COL_RESIDENCE_TAX        = "RESIDENCE_TAX"       ;	// Z
	public static final String COL_NURSING_INSURANCE    = "NURSING_INSURANCE"   ;	// ی
	public static final String COL_DEDUCTION_08         = "DEDUCTION_08"        ;	// T08
	public static final String COL_DEDUCTION_09         = "DEDUCTION_09"        ;	// T09
	public static final String COL_DEDUCTION_10         = "DEDUCTION_10"        ;	// T10
	public static final String COL_DEDUCTION_11         = "DEDUCTION_11"        ;	// T11
	public static final String COL_DEDUCTION_12         = "DEDUCTION_12"        ;	// T12
	public static final String COL_DEDUCTION_13         = "DEDUCTION_13"        ;	// T13
	public static final String COL_DEDUCTION_14         = "DEDUCTION_14"        ;	// T14
	public static final String COL_DEDUCTION_15         = "DEDUCTION_15"        ;	// T15
	public static final String COL_DEDUCTION_16         = "DEDUCTION_16"        ;	// T16
	public static final String COL_DEDUCTION_17         = "DEDUCTION_17"        ;	// T17
	public static final String COL_DEDUCTION_18         = "DEDUCTION_18"        ;	// T18
	public static final String COL_DEDUCTION_19         = "DEDUCTION_19"        ;	// T19
	public static final String COL_DEDUCTION_20         = "DEDUCTION_20"        ;	// T20
	public static final String COL_ALLOWANCE_TOTAL      = "ALLOWANCE_TOTAL"     ;	// xz
	public static final String COL_DEDUCTION_TOTAL      = "DEDUCTION_TOTAL"     ;	// Tz
	public static final String COL_PAYMENT_TOTAL        = "PAYMENT_TOTAL"       ;	// xz
	public static final String COL_BANK1_PAY_AMOUNT     = "BANK1_PAY_AMOUNT"    ;	// s1Uz
	public static final String COL_BANK2_PAY_AMOUNT     = "BANK2_PAY_AMOUNT"    ;	// s2Uz
	public static final String COL_CASH_PAY_AMOUNT      = "CASH_PAY_AMOUNT"     ;	// xz
	public static final String COL_DEPENDENT_COUNT      = "DEPENDENT_COUNT"     ;	// }{̐
	public static final String COL_AMOUNT_TO_TAXATION   = "AMOUNT_TO_TAXATION"  ;	// ېőΏۊz
	public static final String COL_AMOUNT_TO_SOC_INS    = "AMOUNT_TO_SOC_INS"   ;	// ЉیΏۊz


	
	/**
	 * RXgN^
	 */
	public PdPaymentDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PdPaymentDto> mappingAll() throws SQLException {
		List<PdPaymentDto> all = new ArrayList<PdPaymentDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PdPaymentDto UD_PAYMENTR[h
	 * @throws SQLException
	 */
	private PdPaymentDto mapping() throws SQLException {
		PdPaymentDto dto = new PdPaymentDto();
		dto.setKCode             (rs.getString(COL_K_CODE              ));	// ЈR[h
		dto.setCalcDate          (rs.getDate  (COL_CALC_DATE           ));	// vZN
		dto.setPayday            (rs.getDate  (COL_PAYDAY              ));	// ^x
		dto.setCalcStatus        (rs.getString(COL_CALC_STATUS         ));	// vZXe[^X
		dto.setKName             (rs.getString(COL_K_NAME              ));	// Ј
		dto.setStationCode       (rs.getString(COL_STATION_CODE        ));	// R[h
		dto.setPositionCode      (rs.getString(COL_POSITION_CODE       ));	// EʃR[h
		dto.setEmploymentType    (rs.getString(COL_EMPLOYMENT_TYPE     ));	// ٗp敪
		dto.setPresence          (rs.getInt   (COL_PRESENCE            ));	// oΓ
		dto.setWorkOnHoliday     (rs.getInt   (COL_WORK_ON_HOLIDAY     ));	// xoΓ
		dto.setParticularHoliday (rs.getInt   (COL_PARTICULAR_HOLIDAY  ));	// ʋxɓ
		dto.setPaidHoliday       (rs.getInt   (COL_PAID_HOLIDAY        ));	// Lxɓ
		dto.setAbsence           (rs.getInt   (COL_ABSENCE             ));	// Γ
		dto.setPaidHolidayRest   (rs.getInt   (COL_PAID_HOLIDAY_REST   ));	// Lc
		dto.setPaymentHours      (rs.getFloat (COL_PAYMENT_HOURS       ));	// 
		dto.setArriveLate        (rs.getInt   (COL_ARRIVE_LATE         ));	// x
		dto.setEffortTime        (rs.getFloat (COL_EFFORT_TIME         ));	// ʁAcƎ
		dto.setEffortAllowance   (rs.getInt   (COL_EFFORT_ALLOWANCE    ));	// ʁAcƎ蓖
		dto.setLateNight         (rs.getFloat (COL_LATE_NIGHT          ));	// [鎞
		dto.setLateNightAllowance(rs.getInt   (COL_LATE_NIGHT_ALLOWANCE));	// [蓖
		dto.setOverLate          (rs.getFloat (COL_OVER_LATE           ));	// [cƎ
		dto.setOverLateAllowance (rs.getInt   (COL_OVER_LATE_ALLOWANCE ));	// [cƎ蓖
		dto.setHolidayTime       (rs.getFloat (COL_HOLIDAY_TIME        ));	// x
		dto.setHolidayAllowance  (rs.getInt   (COL_HOLIDAY_ALLOWANCE   ));	// x蓖
		dto.setAttendance_13     (rs.getFloat (COL_ATTENDANCE_13       ));	// ΑӍ13
		dto.setAttendance_14     (rs.getFloat (COL_ATTENDANCE_14       ));	// ΑӍ14
		dto.setInstitutionalAbs  (rs.getInt   (COL_INSTITUTIONAL_ABS   ));	// xΓ
		dto.setOtherAttendance   (rs.getInt   (COL_OTHER_ATTENDANCE    ));	// ̑Αӓ
		dto.setBasicSalary       (rs.getInt   (COL_BASIC_SALARY        ));	// {
		dto.setAbility1Allowance (rs.getInt   (COL_ABILITY1_ALLOWANCE  ));	// E\蓖1
		dto.setAbility2Allowance (rs.getInt   (COL_ABILITY2_ALLOWANCE  ));	// E\蓖2
		dto.setFamilyAllowance   (rs.getInt   (COL_FAMILY_ALLOWANCE    ));	// }{蓖
		dto.setAllowance_05      (rs.getInt   (COL_ALLOWANCE_05        ));	// x05
		dto.setAllowance_06      (rs.getInt   (COL_ALLOWANCE_06        ));	// x06
		dto.setCutForMissing     (rs.getInt   (COL_CUT_FOR_MISSING     ));	// FΌz
		dto.setCutForShort       (rs.getInt   (COL_CUT_FOR_SHORT       ));	// Ezo
		dto.setAllowance_09      (rs.getInt   (COL_ALLOWANCE_09        ));	// x09
		dto.setAllowance_10      (rs.getInt   (COL_ALLOWANCE_10        ));	// x10
		dto.setAllowance_11      (rs.getInt   (COL_ALLOWANCE_11        ));	// x11
		dto.setAllowance_12      (rs.getInt   (COL_ALLOWANCE_12        ));	// x12
		dto.setAllowance_13      (rs.getInt   (COL_ALLOWANCE_13        ));	// x13
		dto.setDateAllowance     (rs.getInt   (COL_DATE_ALLOWANCE      ));	// t蓖
		dto.setAllowance_15      (rs.getInt   (COL_ALLOWANCE_15        ));	// x15
		dto.setAllowance_16      (rs.getInt   (COL_ALLOWANCE_16        ));	// x16
		dto.setAllowance_17      (rs.getInt   (COL_ALLOWANCE_17        ));	// x17
		dto.setCommutation       (rs.getInt   (COL_COMMUTATION         ));	// ʋΔ
		dto.setCommutationTax    (rs.getInt   (COL_COMMUTATION_TAX     ));	// ېŒʋΔ
		dto.setOvertimeAllowance (rs.getInt   (COL_OVERTIME_ALLOWANCE  ));	// E[Ex
		dto.setCutFromBasic      (rs.getInt   (COL_CUT_FROM_BASIC      ));	// z
		dto.setHealthInsurance   (rs.getInt   (COL_HEALTH_INSURANCE    ));	// Nی
		dto.setPensionInsurance  (rs.getInt   (COL_PENSION_INSURANCE   ));	// Nی
		dto.setPensionFund       (rs.getInt   (COL_PENSION_FUND        ));	// N
		dto.setEmployeeInsurance (rs.getInt   (COL_EMPLOYEE_INSURANCE  ));	// ٗpی
		dto.setIncomeTax         (rs.getInt   (COL_INCOME_TAX          ));	// 
		dto.setResidenceTax      (rs.getInt   (COL_RESIDENCE_TAX       ));	// Z
		dto.setNursingInsurance  (rs.getInt   (COL_NURSING_INSURANCE   ));	// ی
		dto.setDeduction_08      (rs.getInt   (COL_DEDUCTION_08        ));	// T08
		dto.setDeduction_09      (rs.getInt   (COL_DEDUCTION_09        ));	// T09
		dto.setDeduction_10      (rs.getInt   (COL_DEDUCTION_10        ));	// T10
		dto.setDeduction_11      (rs.getInt   (COL_DEDUCTION_11        ));	// T11
		dto.setDeduction_12      (rs.getInt   (COL_DEDUCTION_12        ));	// T12
		dto.setDeduction_13      (rs.getInt   (COL_DEDUCTION_13        ));	// T13
		dto.setDeduction_14      (rs.getInt   (COL_DEDUCTION_14        ));	// T14
		dto.setDeduction_15      (rs.getInt   (COL_DEDUCTION_15        ));	// T15
		dto.setDeduction_16      (rs.getInt   (COL_DEDUCTION_16        ));	// T16
		dto.setDeduction_17      (rs.getInt   (COL_DEDUCTION_17        ));	// T17
		dto.setDeduction_18      (rs.getInt   (COL_DEDUCTION_18        ));	// T18
		dto.setDeduction_19      (rs.getInt   (COL_DEDUCTION_19        ));	// T19
		dto.setDeduction_20      (rs.getInt   (COL_DEDUCTION_20        ));	// T20
		dto.setAllowanceTotal    (rs.getInt   (COL_ALLOWANCE_TOTAL     ));	// xz
		dto.setDeductionTotal    (rs.getInt   (COL_DEDUCTION_TOTAL     ));	// Tz
		dto.setPaymentTotal      (rs.getInt   (COL_PAYMENT_TOTAL       ));	// xz
		dto.setBank1PayAmount    (rs.getInt   (COL_BANK1_PAY_AMOUNT    ));	// s1Uz
		dto.setBank2PayAmount    (rs.getInt   (COL_BANK2_PAY_AMOUNT    ));	// s2Uz
		dto.setCashPayAmount     (rs.getInt   (COL_CASH_PAY_AMOUNT     ));	// xz
		dto.setDependentCount    (rs.getInt   (COL_DEPENDENT_COUNT     ));	// }{̐
		dto.setAmountToTaxation  (rs.getInt   (COL_AMOUNT_TO_TAXATION  ));	// ېőΏۊz
		dto.setAmountToSocIns    (rs.getInt   (COL_AMOUNT_TO_SOC_INS   ));	// ЉیΏۊz
		mappingCommonInfo(dto);
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdPaymentDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PdPaymentDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param calcDate vZN(L[)
	 * @return PdPaymentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PdPaymentDto findForKey(
			String kCode,
			Date   calcDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, calcDate);
			executeQuery();
			PdPaymentDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @param calcDate vZN(L[)
	 * @return PdPaymentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PdPaymentDto findForUpdate(
			String kCode,
			Date   calcDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, calcDate);
			executeQuery();
			PdPaymentDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param startDate ΏۊJnN
	 * @param endDate ΏۏIN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdPaymentDto> findForConditionDate(
			String kCode,
			Date startDate,
			Date endDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_CALC_DATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_CALC_DATE);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<PdPaymentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdPaymentDto> findForCondition(
			Date calcDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, calcDate);
			executeQuery();
			List<PdPaymentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	
	
	/**
	 * ɂf[^擾B<br>
	 * wNɂmς݃f[^𒊏oB<br>
	 * kCodenullɂƁAЈR[hɂwsȂB<br>
	 * ^׏o͎ɗpB
	 * @param calcDate vZN
	 * @param kCode    ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PdPaymentDto> findForFBDataOutputDetail(
			Date calcDate, String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (kCode != null) {
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
		}
		sb.append(COL_CALC_DATE + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_STATUS + " = '" + BonusConst.CALC_STATUS_FIX + "' ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (kCode != null) {
				setParam(index++, kCode);
			}
			setParam(index++, calcDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	
	/**
	 * ɂf[^擾B<br>
	 * wNɂmς݃f[^𒊏oB<br>
	 * kCodenullɂƁAЈR[hɂwsȂB<br>
	 * ^׏o͎ɗpB
	 * @param calcDate vZN
	 * @param kCode    ЈR[h
	 * @param stationCode R[h(Ə)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public  List<PdPaymentDto> findForOutputDetail(
			Date calcDate, String kCode, String stationCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (kCode != null) {
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
		}
		sb.append(COL_CALC_DATE + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_STATUS + " IN ('" + BonusConst.CALC_STATUS_FIX + "','" +BonusConst.CALC_STATUS_FB +"')");
		if (stationCode != null) {
			if (!stationCode.equals("")) {
				sb.append("AND ");
				sb.append(COL_STATION_CODE + " IN  ( " + PmStationDao.getStationQuery() + " ) ");
			}
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (kCode != null) {
				setParam(index++, kCode);
			}
			setParam(index++, calcDate);
			if (stationCode != null) {
				if (!stationCode.equals("")) {
					setParam(index++, stationCode);
				}
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^폜
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public int deleteForCondition(
			Date calcDate
	) throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("DELETE FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		try {
			prepareStatement(sb.toString());
			setParam(index++, calcDate);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PdPaymentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}(Abv[h)
	 * @param aryCsvDate }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 */
	public int insertUpload(
			String[] aryHeaderNo,
			String[] aryCsvData,
			Date calcDate,
			Date payDay,
			String kName,
			String stationCode,
			String employmentType,
			String positionCode
	) throws SQLException {
		try {
			Date date = new Date();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append(" ( ");
			sb.append(createCol(aryHeaderNo,true));
			sb.append(COL_CALC_DATE);
			sb.append(", ");
			sb.append(COL_PAYDAY);
			sb.append(", ");
			sb.append(COL_K_NAME);
			sb.append(", ");
			sb.append(COL_STATION_CODE);
			sb.append(", ");			
			sb.append(COL_CALC_STATUS);
			sb.append(", ");
			sb.append(COL_EMPLOYMENT_TYPE);
			sb.append(", ");
			sb.append(COL_POSITION_CODE);
			sb.append(", ");
			if (!INSERT_DATE.equals("")) {
				sb.append(INSERT_DATE + ", ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append(INSERT_USER + ", ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + ", ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + " ");
			}
			sb.append(" ) VALUES ( ");
			sb.append(insertRow(aryCsvData));
			sb.append("?, ");
			sb.append("?, ");
			sb.append("?, ");
			sb.append("?, ");			
			sb.append("?, ");
			sb.append("?, ");			
			sb.append("?, ");
			if (!INSERT_DATE.equals("")) {
				sb.append("?, ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append("?, ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append("?, ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append("?  ");
			}
			sb.append(" ) ");
			prepareStatement(sb.toString());
			for (int i = 0; i < aryCsvData.length; i++) {
				setParam(index++, aryCsvData[i]);
			}
			setParam(index++, calcDate);
			setParam(index++, payDay);
			setParam(index++, kName);
			setParam(index++, stationCode);
			setParam(index++, BonusConst.CALC_STATUS_CRE);
			setParam(index++, employmentType);
			setParam(index++, positionCode);
			if (!INSERT_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!INSERT_USER.equals("")) {
				setParam(index++, userId);
			}
			if (!UPDATE_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!UPDATE_USER.equals("")) {
				setParam(index++, userId);
			}
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * IĴSQL쐬
	 * @param aryHeaderNo
	 * @param isInsert
	 * @return
	 */
	public String createCol(
			String[] aryHeaderNo,
			boolean isInsert
		) {
			index = 1;
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < aryHeaderNo.length; i++) {
				sb.append(getColumn(Integer.parseInt(aryHeaderNo[i])));
				if (!isInsert) {
					sb.append(" = ? ");
				}
				sb.append(BonusConst.STR_CSV_SEPARATOR);
			}
			return sb.toString();
		
	}
	
	/**
	 * o^p[^
	 * @param aryCsvData
	 * @return
	 */
	public String insertRow(
			String[] aryCsvData
		) {
			index = 1;
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < aryCsvData.length; i++) {
				sb.append(" ? ");
				sb.append(BonusConst.STR_CSV_SEPARATOR);
			}
			return sb.toString();
		
	}
	
	/**
	 * f[^XV(Abv[h)
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 */
	public int updateUpload(
			String[] aryHeaderNo,
			String[] aryCsvData,
			String   kCode,
			Date   calcDate,
			String kName,
			String stationCode,
			String employmentType,
			String positionCode
	) throws SQLException {
		try {
			Date date = new Date();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("UPDATE ");
			sb.append(TABLE);
			sb.append(" SET ");
			sb.append(createCol(aryHeaderNo,false));
			sb.append(COL_CALC_DATE + " = ?, ");
			sb.append(COL_K_NAME + " = ?, ");
			sb.append(COL_STATION_CODE + " = ?, ");			
			sb.append(COL_CALC_STATUS + " = ?, ");
			sb.append(COL_EMPLOYMENT_TYPE + " = ?, ");
			sb.append(COL_POSITION_CODE + " = ?, ");
			
			sb.append(COL_ALLOWANCE_TOTAL    + " = ?, ");
			sb.append(COL_DEDUCTION_TOTAL    + " = ?, ");
			sb.append(COL_PAYMENT_TOTAL      + " = ?, ");
			sb.append(COL_BANK1_PAY_AMOUNT   + " = ?, ");
			sb.append(COL_BANK2_PAY_AMOUNT   + " = ?, ");
			sb.append(COL_CASH_PAY_AMOUNT    + " = ?, ");
			sb.append(COL_AMOUNT_TO_TAXATION + " = ?, ");
			sb.append(COL_AMOUNT_TO_SOC_INS  + " = ?, ");
			
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + " = ?, ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + " = ? ");
			}
			sb.append(" WHERE ");
			sb.append(COL_K_CODE);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_CALC_DATE);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			for (int i = 0; i < aryCsvData.length; i++) {
				setParam(index++, aryCsvData[i]);
			}
			setParam(index++, calcDate);
			setParam(index++, kName);
			setParam(index++, stationCode);
			setParam(index++, BonusConst.CALC_STATUS_CRE);
			setParam(index++, employmentType);
			setParam(index++, positionCode);
			
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			setParam(index++, 0);
			if (!UPDATE_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!UPDATE_USER.equals("")) {
				setParam(index++, userId);
			}
			setParam(index++, kCode);
			setParam(index++, calcDate);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @param needLog Oo͗v
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PdPaymentDto dto, boolean needLog) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @param needLog Oo͗v
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(
			PdPaymentDto dto, boolean needLog
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getCalcDate());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PdPaymentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getCalcDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(l}X^ێ-Јꗗp)
	 * @param kCode          ЈR[h
	 * @param kName          Ј
	 * @param kKana          ض
	 * @param stationCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<PdPaymentDto> findForPaymentList(
			String kCode,
			String kName,
			String stationCode,
			String statusData
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		if (
			kCode        != null && !kCode.equals       ("") ||
			kName        != null && !kName.equals       ("") ||
			stationCode  != null && !stationCode.equals ("") ||
			statusData   != null && !statusData.equals  ("")
		) {
			sb.append("WHERE ");
		}		
		if (kCode != null && !kCode.equals("")) {
			sb.append(COL_K_CODE + " =  ? ");
			if (
					kName        != null && !kName.equals       ("") ||
					stationCode  != null && !stationCode.equals ("") ||
					statusData   != null && !statusData.equals  ("")
				) {
				sb.append("AND ");
			}		
		}
		if (kName != null && !kName.equals("")) {
			sb.append(COL_K_NAME + " =  ? ");
			if (
					
					stationCode  != null && !stationCode.equals ("") ||
					statusData   != null && !statusData.equals  ("")
				) {
				sb.append("AND ");
			}		
		}
		if (stationCode != null && !stationCode.equals("")) {
			sb.append(COL_STATION_CODE + " =  ? ");
			if (
					statusData   != null && !statusData.equals  ("")
				) {
				sb.append("AND ");
			}		
		}		
		if (statusData != null && !statusData.equals("")) {
			sb.append(COL_CALC_STATUS + " =  ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (kCode != null && !kCode.equals("")) {
				setParam(index++, kCode);
			}
			if (kName != null && !kName.equals("")) {
				setParam(index++, kName);
			}
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}		
			if (statusData != null && !statusData.equals("")) {
				setParam(index++, statusData);
			}
			// s
			executeQuery();
			List<PdPaymentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PdPaymentDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode             ());	// ЈR[h
		setParam(index++, dto.getCalcDate          ());	// vZN
		setParam(index++, dto.getPayday            ());	// ^x
		setParam(index++, dto.getCalcStatus        ());	// vZXe[^X
		setParam(index++, dto.getKName             ());	// Ј
		setParam(index++, dto.getStationCode       ());	// R[h
		setParam(index++, dto.getPositionCode      ());	// EʃR[h
		setParam(index++, dto.getEmploymentType    ());	// ٗp敪
		setParam(index++, dto.getPresence          ());	// oΓ
		setParam(index++, dto.getWorkOnHoliday     ());	// xoΓ
		setParam(index++, dto.getParticularHoliday ());	// ʋxɓ
		setParam(index++, dto.getPaidHoliday       ());	// Lxɓ
		setParam(index++, dto.getAbsence           ());	// Γ
		setParam(index++, dto.getPaidHolidayRest   ());	// Lc
		setParam(index++, dto.getPaymentHours      ());	// 
		setParam(index++, dto.getArriveLate        ());	// x
		setParam(index++, dto.getEffortTime        ());	// ʁAcƎ
		setParam(index++, dto.getEffortAllowance   ());	// ʁAcƎ蓖
		setParam(index++, dto.getLateNight         ());	// [鎞
		setParam(index++, dto.getLateNightAllowance());	// [蓖
		setParam(index++, dto.getOverLate          ());	// [cƎ
		setParam(index++, dto.getOverLateAllowance ());	// [cƎ蓖
		setParam(index++, dto.getHolidayTime       ());	// x
		setParam(index++, dto.getHolidayAllowance  ());	// x蓖
		setParam(index++, dto.getAttendance_13     ());	// ΑӍ13
		setParam(index++, dto.getAttendance_14     ());	// ΑӍ14
		setParam(index++, dto.getInstitutionalAbs  ());	// xΓ
		setParam(index++, dto.getOtherAttendance   ());	// ̑Αӓ
		setParam(index++, dto.getBasicSalary       ());	// {
		setParam(index++, dto.getAbility1Allowance ());	// E\蓖1
		setParam(index++, dto.getAbility2Allowance ());	// E\蓖2
		setParam(index++, dto.getFamilyAllowance   ());	// }{蓖
		setParam(index++, dto.getAllowance_05      ());	// x05
		setParam(index++, dto.getAllowance_06      ());	// x06
		setParam(index++, dto.getCutForMissing     ());	// FΌz
		setParam(index++, dto.getCutForShort       ());	// Ezo
		setParam(index++, dto.getAllowance_09      ());	// x09
		setParam(index++, dto.getAllowance_10      ());	// x10
		setParam(index++, dto.getAllowance_11      ());	// x11
		setParam(index++, dto.getAllowance_12      ());	// x12
		setParam(index++, dto.getAllowance_13      ());	// x13
		setParam(index++, dto.getDateAllowance     ());	// t蓖
		setParam(index++, dto.getAllowance_15      ());	// x15
		setParam(index++, dto.getAllowance_16      ());	// x16
		setParam(index++, dto.getAllowance_17      ());	// x17
		setParam(index++, dto.getCommutation       ());	// ʋΔ
		setParam(index++, dto.getCommutationTax    ());	// ېŒʋΔ
		setParam(index++, dto.getOvertimeAllowance ());	// E[Ex
		setParam(index++, dto.getCutFromBasic      ());	// z
		setParam(index++, dto.getHealthInsurance   ());	// Nی
		setParam(index++, dto.getPensionInsurance  ());	// Nی
		setParam(index++, dto.getPensionFund       ());	// N
		setParam(index++, dto.getEmployeeInsurance ());	// ٗpی
		setParam(index++, dto.getIncomeTax         ());	// 
		setParam(index++, dto.getResidenceTax      ());	// Z
		setParam(index++, dto.getNursingInsurance  ());	// ی
		setParam(index++, dto.getDeduction_08      ());	// T08
		setParam(index++, dto.getDeduction_09      ());	// T09
		setParam(index++, dto.getDeduction_10      ());	// T10
		setParam(index++, dto.getDeduction_11      ());	// T11
		setParam(index++, dto.getDeduction_12      ());	// T12
		setParam(index++, dto.getDeduction_13      ());	// T13
		setParam(index++, dto.getDeduction_14      ());	// T14
		setParam(index++, dto.getDeduction_15      ());	// T15
		setParam(index++, dto.getDeduction_16      ());	// T16
		setParam(index++, dto.getDeduction_17      ());	// T17
		setParam(index++, dto.getDeduction_18      ());	// T18
		setParam(index++, dto.getDeduction_19      ());	// T19
		setParam(index++, dto.getDeduction_20      ());	// T20
		setParam(index++, dto.getAllowanceTotal    ());	// xz
		setParam(index++, dto.getDeductionTotal    ());	// Tz
		setParam(index++, dto.getPaymentTotal      ());	// xz
		setParam(index++, dto.getBank1PayAmount    ());	// s1Uz
		setParam(index++, dto.getBank2PayAmount    ());	// s2Uz
		setParam(index++, dto.getCashPayAmount     ());	// xz
		setParam(index++, dto.getDependentCount    ());	// }{̐
		setParam(index++, dto.getAmountToTaxation  ());	// ېőΏۊz
		setParam(index++, dto.getAmountToSocIns    ());	// ЉیΏۊz
		setCommonParams(isInsert);
	}

	/**
	 * J擾
	 * @param idx
	 * @return J
	 */
	
	public String getColumn(
			int idx
		) {
		switch (idx) {
		case 0  : return COL_K_CODE             ; // ЈR[h
		case 1  : return COL_ALLOWANCE_05       ; // x05
		case 2  : return COL_ALLOWANCE_06       ; // x06
		case 3  : return COL_ALLOWANCE_09       ; // x09
		case 4  : return COL_ALLOWANCE_10       ; // x10
		case 5  : return COL_ALLOWANCE_11       ; // x11
		case 6  : return COL_ALLOWANCE_12       ; // x12
		case 7  : return COL_ALLOWANCE_13       ; // x13
		case 8  : return COL_ALLOWANCE_15       ; // x15
		case 9  : return COL_ALLOWANCE_16       ; // x16
		case 10 : return COL_ALLOWANCE_17       ; // x17
		case 11 : return COL_DEDUCTION_08       ; // T08
		case 12 : return COL_DEDUCTION_09       ; // T09
		case 13 : return COL_DEDUCTION_10       ; // T10
		case 14 : return COL_DEDUCTION_11       ; // T11
		case 15 : return COL_DEDUCTION_12       ; // T12
		case 16 : return COL_DEDUCTION_13       ; // T13
		case 17 : return COL_DEDUCTION_14       ; // T14
		case 18 : return COL_DEDUCTION_15       ; // T15
		case 19 : return COL_DEDUCTION_16       ; // T16
		case 20 : return COL_DEDUCTION_17       ; // T17
		case 21 : return COL_DEDUCTION_18       ; // T18
		case 22 : return COL_DEDUCTION_19       ; // T19
		case 23 : return COL_DEDUCTION_20       ; // T20
		default:
			return "";
		}
		
	}
}
